/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloPaginaAsistente;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.asistentes.PaginaAsistente;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.exportacion.valores.ModeloValoresCompExportacion;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.ComprobanteExportacion;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.swt.SWTResourceManager;

public class PaginaComprobante
extends PaginaAsistente
implements VistaModelo<ComprobanteExportacion>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private ModeloValoresCompExportacion modeloValores;
    private ComprobanteExportacion modeloDatos;
    private Text txtFOBLocal;
    private Text txtNumAutorizacion;
    private Text txtEstablecimiento;
    private Text txtPuntoEmision;
    private Text txtNumSerie;
    private ComboViewer cvTipoComprobante;

    public PaginaComprobante(boolean editando) {
        super(PaginaComprobante.class.getName(), "Anexo Transaccional", "Especifique la informaci\u00f3n correspondiente");
        this.setMessage("Especifique la informaci\u00f3n correspondiente al comprobante");
        this.setTitle("Comprobante Exportaci\u00f3n");
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresCompExportacion(((Iva)this.modeloDatos.getRaizModelo()).periodo.getFechaDeclarada());
        this.modeloValores.inicializar();
    }

    public void setModeloDatos(ComprobanteExportacion modeloDatos) {
        this.modeloDatos = modeloDatos;
        this.modeloDatos.setObligatorio(true);
    }

    public void procesarModeloDatos() {
        String codigoTipoComprobante = this.modeloDatos.getTipoComprobante();
        ElementoNombreValor tipoComprobante = this.modeloValores.obtenerTipoComprobante(codigoTipoComprobante);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoComprobante, (Object)tipoComprobante);
        ListenerValidacionModeloPaginaAsistente listener = new ListenerValidacionModeloPaginaAsistente((InformacionValidable)this.modeloDatos, (PaginaAsistente)this);
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)listener);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblTipoDeComprobante = new Label(container, 0);
        lblTipoDeComprobante.setText("Tipo de Comprobante");
        this.cvTipoComprobante = new ComboViewer(container, 8);
        this.cvTipoComprobante.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoComprobante = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoComprobante != null) {
                    PaginaComprobante.this.modeloDatos.setTipoComprobante((String)tipoComprobante.getValor());
                    PaginaComprobante.this.modeloDatos.setDescripcionTipoComprobante(tipoComprobante.getNombre());
                }
            }
        });
        Combo combo = this.cvTipoComprobante.getCombo();
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 150;
        combo.setLayoutData((Object)gd_combo);
        Label lblValorDelComprobante = new Label(container, 0);
        lblValorDelComprobante.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblValorDelComprobante.setText("Valor FOB del Comprobante Local");
        this.txtFOBLocal = new Text(container, 2048);
        this.txtFOBLocal.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobante.this.txtFOBLocal.selectAll();
            }
        });
        this.txtFOBLocal.setTextLimit(15);
        GridData gd_txtFOBLocal = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtFOBLocal.widthHint = 100;
        this.txtFOBLocal.setLayoutData((Object)gd_txtFOBLocal);
        Label lblFacturaDeExportaciones = new Label(container, 0);
        lblFacturaDeExportaciones.setFont(SWTResourceManager.getBoldFont((Font)lblFacturaDeExportaciones.getFont()));
        GridData gd_lblFacturaDeExportaciones = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblFacturaDeExportaciones.verticalIndent = 10;
        lblFacturaDeExportaciones.setLayoutData((Object)gd_lblFacturaDeExportaciones);
        lblFacturaDeExportaciones.setText("Factura de Exportaciones");
        new Label(container, 0);
        new Label(container, 0);
        Composite composite = new Composite(container, 0);
        GridLayout gl_composite = new GridLayout(3, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        Label lblEstablecimiento = new Label(composite, 0);
        lblEstablecimiento.setText("Establecimiento");
        Label lblPuntoDeEmisin = new Label(composite, 0);
        lblPuntoDeEmisin.setText("Punto de Emisi\u00f3n");
        Label lblSerial = new Label(composite, 0);
        lblSerial.setText("Secuencial");
        this.txtEstablecimiento = new Text(composite, 2048);
        this.txtEstablecimiento.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobante.this.txtEstablecimiento.selectAll();
            }
        });
        this.txtEstablecimiento.setTextLimit(3);
        this.txtEstablecimiento.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtPuntoEmision = new Text(composite, 2048);
        this.txtPuntoEmision.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobante.this.txtPuntoEmision.selectAll();
            }
        });
        this.txtPuntoEmision.setTextLimit(3);
        this.txtPuntoEmision.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtNumSerie = new Text(composite, 2048);
        this.txtNumSerie.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobante.this.txtNumSerie.selectAll();
            }
        });
        this.txtNumSerie.setTextLimit(9);
        GridData gd_txtNumSerie = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtNumSerie.widthHint = 100;
        this.txtNumSerie.setLayoutData((Object)gd_txtNumSerie);
        Label lblNDeAutorizacin = new Label(container, 0);
        lblNDeAutorizacin.setText("N\u00b0 de Autorizaci\u00f3n");
        this.txtNumAutorizacion = new Text(container, 2048);
        this.txtNumAutorizacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PaginaComprobante.this.txtNumAutorizacion.selectAll();
            }
        });
        this.txtNumAutorizacion.setTextLimit(49);
        GridData gd_txtNumAutorizacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumAutorizacion.widthHint = 220;
        this.txtNumAutorizacion.setLayoutData((Object)gd_txtNumAutorizacion);
        Label lblFechaDeEmisin = new Label(container, 0);
        lblFechaDeEmisin.setText("Fecha de Emisi\u00f3n");
        final CDateTime dstFechaEmision = new CDateTime(container, 32771);
        dstFechaEmision.setNullText("seleccione la fecha");
        dstFechaEmision.setPattern("dd/MM/yyyy");
        dstFechaEmision.setSelection(this.modeloDatos.getFechaEmision());
        dstFechaEmision.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaComprobante.this.modeloDatos.setFechaEmision(dstFechaEmision.getSelection());
            }
        });
        GridData gd_dstFechaEmision = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_dstFechaEmision.widthHint = 125;
        dstFechaEmision.setLayoutData((Object)gd_dstFechaEmision);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtFOBLocalObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtFOBLocal);
        IObservableValue comprobanteExportacionvalorComprobanteLocalModeloDatosObserveValue = BeanProperties.value((String)"valorComprobanteLocal").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtFOBLocalObserveWidget, comprobanteExportacionvalorComprobanteLocalModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtEstablecimientoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtEstablecimiento);
        IObservableValue comprobanteExportacionestablecimientoModeloDatosObserveValue = BeanProperties.value((String)"establecimiento").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtEstablecimientoObserveWidget, comprobanteExportacionestablecimientoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtPuntoEmisionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtPuntoEmision);
        IObservableValue comprobanteExportacionpuntoEmisionModeloDatosObserveValue = BeanProperties.value((String)"puntoEmision").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtPuntoEmisionObserveWidget, comprobanteExportacionpuntoEmisionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumSerieObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumSerie);
        IObservableValue comprobanteExportacionsecuencialModeloDatosObserveValue = BeanProperties.value((String)"secuencial").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumSerieObserveWidget, comprobanteExportacionsecuencialModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumAutorizacionObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtNumAutorizacion);
        IObservableValue comprobanteExportacionnumAutorizacionModeloDatosObserveValue = BeanProperties.value((String)"numAutorizacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumAutorizacionObserveWidget, comprobanteExportacionnumAutorizacionModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoComprobante.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoComprobante.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tipoComprobanteModeloValoresObserveList = PojoProperties.list((String)"tipoComprobante").observe((Object)this.modeloValores);
        this.cvTipoComprobante.setInput((Object)tipoComprobanteModeloValoresObserveList);
        return bindingContext;
    }
}

